/*
 * Decompiled with CFR 0.152.
 */
package com.titan.clients;

import com.titan.clients.InitializeDB;
import com.titan.domain.Customer;
import com.titan.domain.Ship;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;

public class Literals {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HashMap map = new HashMap();
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"titan", map);
        EntityManager entityManager = factory.createEntityManager();
        entityManager.getTransaction().begin();
        try {
            System.out.println("Initialize DB");
            InitializeDB.initialize(entityManager);
            System.out.println();
            System.out.println();
            Literals.literals(entityManager);
        }
        finally {
            entityManager.getTransaction().commit();
            entityManager.close();
            factory.close();
        }
    }

    public static void literals(EntityManager manager) {
        System.out.println("THE WHERE CLAUSE AND LITERALS");
        System.out.println("--------------------------------");
        System.out.println("SELECT c FROM Customer AS c");
        System.out.println("WHERE c.creditCard.creditCompany.name = 'Capital One'");
        Query query = manager.createQuery("SELECT c FROM Customer AS c WHERE c.creditCard.creditCompany.name = 'Capital One'");
        List customers = query.getResultList();
        for (Customer cust : customers) {
            System.out.println("   " + cust.getFirstName() + " has a Capital One card.");
        }
        System.out.println("");
        System.out.println("SELECT s FROM Ship AS s");
        System.out.println("WHERE s.tonnage = 100000.0");
        query = manager.createQuery("SELECT s FROM Ship AS s WHERE s.tonnage = 100000.0");
        List ships = query.getResultList();
        for (Ship ship : ships) {
            System.out.println("   Ship " + ship.getName() + " as tonnage 100000.0");
        }
        System.out.println("");
        System.out.println("SELECT c FROM Customer AS c");
        System.out.println("WHERE c.hasGoodCredit = TRUE");
        query = manager.createQuery("SELECT c FROM Customer AS c WHERE c.hasGoodCredit = TRUE");
        customers = query.getResultList();
        for (Customer cust : customers) {
            System.out.println("   " + cust.getFirstName() + " has good credit.");
        }
        System.out.println("");
    }
}

