/*
 * Decompiled with CFR 0.152.
 */
package com.titan.processpayment;

import com.titan.domain.Customer;
import com.titan.domain.Payment;
import com.titan.processpayment.CheckDO;
import com.titan.processpayment.CreditCardDO;
import com.titan.processpayment.PaymentException;
import com.titan.processpayment.ProcessPaymentLocal;
import java.util.Date;
import javax.annotation.Resource;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;

@Stateful
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class ProcessPaymentBean
implements ProcessPaymentLocal {
    public static final String CASH = "CASH";
    public static final String CREDIT = "CREDIT";
    public static final String CHECK = "CHECK";
    @PersistenceContext(unitName="titan", type=PersistenceContextType.EXTENDED)
    private EntityManager entityManager;
    @Resource(name="min")
    int minCheckNumber = 100;

    @Override
    public boolean byCash(Customer customer, double amount) throws PaymentException {
        return this.process(customer, amount, CASH, null, -1, null, null);
    }

    @Override
    public boolean byCheck(Customer customer, CheckDO check, double amount) throws PaymentException {
        if (check.checkNumber > this.minCheckNumber) {
            return this.process(customer, amount, CHECK, check.checkBarCode, check.checkNumber, null, null);
        }
        throw new PaymentException("Check number is too low. Must be at least " + this.minCheckNumber);
    }

    @Override
    public boolean byCredit(Customer customer, CreditCardDO card, double amount) throws PaymentException {
        if (card.expiration.before(new Date())) {
            throw new PaymentException("Expiration date has passed");
        }
        return this.process(customer, amount, CREDIT, null, -1, card.number, new java.sql.Date(card.expiration.getTime()));
    }

    private boolean process(Customer cust, double amount, String type, String checkBarCode, int checkNumber, String creditNumber, java.sql.Date creditExpDate) throws PaymentException {
        Payment payment = new Payment();
        payment.setCustomer(cust);
        payment.setAmount(amount);
        payment.setType(type);
        payment.setCheckBarCode(checkBarCode);
        payment.setCheckNumber(checkNumber);
        payment.setCreditCard(creditNumber);
        payment.setCreditCardExpiration(creditExpDate);
        this.entityManager.persist((Object)payment);
        return true;
    }
}

