package com.titan.domain;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="CUSTOMER_TABLE")
public class Customer implements java.io.Serializable 
{
   private int id;
   private String lastName;
   private String firstName;
   private CustomerType customerType;
   private Date timeCreated = new Date();
   private JPEG picture;
   
   @Id
   @GeneratedValue
   @Column(name = "CUST_ID")
   public int getId() {
       return id;
   }
   
   public void setId(int pk) 
   {
      id = pk;
   }

   public String getLastName() { return lastName; }
   public void setLastName(String lastName) { this.lastName = lastName; }

   public String getFirstName() { return firstName; }
   public void setFirstName(String firstName) { this.firstName = firstName; }

   @Enumerated(EnumType.STRING)
   public CustomerType getCustomerType() {
        return CustomerType.values()[customerType.ordinal()];
    }
   public void setCustomerType(CustomerType type) {
       customerType = type;
   }

   @Temporal(TemporalType.TIME)
   public Date getTimeCreated() { return timeCreated; }
   public void setTimeCreated(Date time) { timeCreated = time; }

   @Lob
    @Basic(fetch = FetchType.LAZY)
    public byte[] getPictureBytes() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oo = new ObjectOutputStream(os);

            oo.writeObject(picture);
            oo.close();
            os.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return os.toByteArray();
    }

    public void setPictureBytes(byte[] jpeg) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(jpeg);
            ObjectInputStream oi = new ObjectInputStream(is);
            picture = (JPEG) oi.readObject();
            oi.close();
            is.close();
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
   
   @Transient
   public JPEG getPicture() { return picture; }
   public void setPicture(JPEG jpeg) { picture = jpeg; }

}

 

    
    

    
